
/* This file contain information relating to the format of ZIP file. ZIP    */
/* files are produced by PKZIP.EXE by PKWARE.				    */

#define LOCALHEADERSIG	0x04034b50L
#define CENTRALDIRSIG	0x02014b50L
#define ENDCENTRALSIG	0x06054b50L

/* These structures must be byte aligned */

#pragma pack(1)

/* Structure of the local file header */

struct LOCAL_HEADER
  {
  long	Signature;
  int	Version;
  int	BitFlag;
  int	CompressionMethod;
  unsigned FileTime;
  unsigned FileDate;
  long	CRC32;
  long	CompressedSize;
  long	UnCompressedSize;
  int	FileNameLength;
  int	ExtraFieldLength;
  };

/* Structure of the central directory record */
struct CENTRAL_RECORD
  {
  long	Signature;
  int	VersionMadeBy;
  int	VersionNeeded;
  int	BitFlag;
  int	CompressionMethod;
  int	FileTime;
  int	FileDate;
  long	CRC32;
  long	CompressedSize;
  long	UnCompressedSize;
  int	FileNameLength;
  int	ExtraFieldLength;
  int	CommentFieldLength;
  int	DiskStartNumber;
  int	InternalAttributes;
  long	ExternalAttributes;
  long	LocalHeaderOffset;
  };

struct END_CENTRAL_RECORD
  {
  long	Signature;
  int	DiskNumber;
  int	DiskWithCentralDir;
  int	DiskCentralDir;
  int	CentralDirEntries;
  long	CentralDirSize;
  long	CentralDirOffset;
  int	ZipCommentLength;
  };

#define SIZELHR sizeof( struct LOCAL_HEADER )
#define SIZECDR sizeof( struct CENTRAL_RECORD )
#define SIZEEDR sizeof( struct END_CENTRAL_RECORD )

